VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Begin VB.Form frmSweepChart 
   Caption         =   "2520 Sweep Chart"
   ClientHeight    =   7575
   ClientLeft      =   4005
   ClientTop       =   3120
   ClientWidth     =   9945
   LinkTopic       =   "Form1"
   ScaleHeight     =   7575
   ScaleWidth      =   9945
   Begin VB.CommandButton cmdExcelPlot 
      Caption         =   "Chart in Excel"
      Height          =   495
      Left            =   7560
      TabIndex        =   34
      Top             =   6960
      Width           =   1215
   End
   Begin VB.Frame fraSweepChartScale 
      Caption         =   "Scale Factors"
      Height          =   855
      Left            =   360
      TabIndex        =   22
      Top             =   120
      Width           =   5895
      Begin VB.CommandButton cmdReplot 
         Caption         =   "Replot"
         Height          =   375
         Left            =   4680
         TabIndex        =   33
         Top             =   290
         Width           =   975
      End
      Begin VB.TextBox txtScale2ndDeriv 
         Height          =   285
         Left            =   3720
         TabIndex        =   31
         Text            =   "Text1"
         Top             =   480
         Width           =   615
      End
      Begin VB.TextBox txtScale1stDeriv 
         Height          =   285
         Left            =   2900
         TabIndex        =   29
         Text            =   "Text1"
         Top             =   480
         Width           =   615
      End
      Begin VB.TextBox txtScaleDet2Curr 
         Height          =   285
         Left            =   2040
         TabIndex        =   27
         Text            =   "Text1"
         Top             =   480
         Width           =   615
      End
      Begin VB.TextBox txtScaleDet1Curr 
         Height          =   285
         Left            =   1200
         TabIndex        =   25
         Text            =   "Text1"
         Top             =   480
         Width           =   615
      End
      Begin VB.TextBox txtScaleLDVolt 
         Height          =   285
         Left            =   240
         TabIndex        =   23
         Text            =   "Text1"
         Top             =   480
         Width           =   615
      End
      Begin VB.Shape Shape1 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H000000FF&
         FillStyle       =   0  'Solid
         Height          =   285
         Index           =   4
         Left            =   4320
         Top             =   480
         Width           =   135
      End
      Begin VB.Shape Shape1 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00C000C0&
         FillStyle       =   0  'Solid
         Height          =   285
         Index           =   3
         Left            =   3480
         Top             =   480
         Width           =   135
      End
      Begin VB.Shape Shape1 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H0000FF00&
         FillStyle       =   0  'Solid
         Height          =   285
         Index           =   2
         Left            =   2640
         Top             =   480
         Width           =   135
      End
      Begin VB.Shape Shape1 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00E89C00&
         FillStyle       =   0  'Solid
         Height          =   285
         Index           =   1
         Left            =   1800
         Top             =   480
         Width           =   135
      End
      Begin VB.Shape Shape1 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00C00000&
         FillStyle       =   0  'Solid
         Height          =   285
         Index           =   0
         Left            =   840
         Top             =   480
         Width           =   135
      End
      Begin VB.Label lbl2ndDeriv 
         Caption         =   "2nd Deriv"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   3720
         TabIndex        =   32
         Top             =   240
         Width           =   735
      End
      Begin VB.Label lbl1stDeriv 
         Caption         =   "1st Deriv"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   2900
         TabIndex        =   30
         Top             =   240
         Width           =   855
      End
      Begin VB.Label lblDet2 
         Caption         =   "Det 2 Curr"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   2040
         TabIndex        =   28
         Top             =   240
         Width           =   855
      End
      Begin VB.Label lblDet1 
         Caption         =   "Det 1 Curr"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   1200
         TabIndex        =   26
         Top             =   240
         Width           =   855
      End
      Begin VB.Label lblLDVolt 
         Caption         =   "LD Voltage"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   240
         TabIndex        =   24
         Top             =   240
         Width           =   855
      End
   End
   Begin VB.TextBox txtTime 
      Alignment       =   1  'Right Justify
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   20
      Top             =   6360
      Width           =   1455
   End
   Begin VB.Frame fraSweepParam 
      Caption         =   "Sweep Parameters"
      Height          =   1695
      Left            =   120
      TabIndex        =   0
      Top             =   5880
      Width           =   6735
      Begin VB.TextBox txtThresoldCurrent 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   120
         Locked          =   -1  'True
         TabIndex        =   14
         TabStop         =   0   'False
         Top             =   1320
         Width           =   975
      End
      Begin VB.TextBox txtKinkMaxima 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   1200
         Locked          =   -1  'True
         TabIndex        =   13
         TabStop         =   0   'False
         Top             =   1320
         Width           =   975
      End
      Begin VB.TextBox txtKinkMinima 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   2280
         Locked          =   -1  'True
         TabIndex        =   12
         TabStop         =   0   'False
         Top             =   1320
         Width           =   975
      End
      Begin VB.TextBox txtKinkStddev 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   3360
         Locked          =   -1  'True
         TabIndex        =   11
         TabStop         =   0   'False
         Top             =   1320
         Width           =   975
      End
      Begin VB.TextBox txtPulseWidth 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         Height          =   280
         Left            =   3720
         Locked          =   -1  'True
         TabIndex        =   5
         TabStop         =   0   'False
         Text            =   "Text1"
         Top             =   480
         Width           =   800
      End
      Begin VB.TextBox txtPulseDelay 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         Height          =   280
         Left            =   5040
         Locked          =   -1  'True
         TabIndex        =   4
         TabStop         =   0   'False
         Text            =   "Text1"
         Top             =   480
         Width           =   800
      End
      Begin VB.TextBox txtSteps 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         Height          =   280
         Left            =   2880
         Locked          =   -1  'True
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   480
         Width           =   600
      End
      Begin VB.TextBox txtStart 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         Height          =   280
         Left            =   240
         Locked          =   -1  'True
         TabIndex        =   2
         TabStop         =   0   'False
         Text            =   "Text2"
         Top             =   480
         Width           =   800
      End
      Begin VB.TextBox txtStop 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         Height          =   280
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   1
         TabStop         =   0   'False
         Text            =   "Text3"
         Top             =   480
         Width           =   800
      End
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "Threshold Current"
         Height          =   375
         Left            =   120
         TabIndex        =   18
         Top             =   910
         Width           =   1095
      End
      Begin VB.Label Label8 
         Alignment       =   2  'Center
         Caption         =   "Kink Maxima"
         Height          =   375
         Left            =   1320
         TabIndex        =   17
         Top             =   910
         Width           =   855
      End
      Begin VB.Label Label9 
         Alignment       =   2  'Center
         Caption         =   "Kink Minima"
         Height          =   375
         Left            =   2400
         TabIndex        =   16
         Top             =   910
         Width           =   735
      End
      Begin VB.Label Label10 
         Alignment       =   2  'Center
         Caption         =   "Kink Stddev"
         Height          =   375
         Left            =   3480
         TabIndex        =   15
         Top             =   910
         Width           =   735
      End
      Begin VB.Label lblPulseWidth 
         Caption         =   "Pulse Width (us)"
         Height          =   255
         Left            =   3600
         TabIndex        =   10
         Top             =   240
         Width           =   1215
      End
      Begin VB.Label lblPulseDelay 
         Caption         =   "Pulse Off Time (us)"
         Height          =   255
         Left            =   4920
         TabIndex        =   9
         Top             =   240
         Width           =   1335
      End
      Begin VB.Label lblStop 
         Caption         =   "Stop Current (A)"
         Height          =   255
         Left            =   1440
         TabIndex        =   8
         Top             =   240
         Width           =   1215
      End
      Begin VB.Label lblStart 
         Caption         =   "Start Current (A)"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   240
         Width           =   1215
      End
      Begin VB.Label lblSteps 
         Caption         =   "Steps"
         Height          =   255
         Left            =   2880
         TabIndex        =   6
         Top             =   240
         Width           =   495
      End
   End
   Begin MSChart20Lib.MSChart MSChart1 
      Height          =   4695
      Left            =   120
      OleObjectBlob   =   "frmSweepChart.frx":0000
      TabIndex        =   19
      Top             =   1080
      Width           =   9615
   End
   Begin VB.Image Image3 
      Appearance      =   0  'Flat
      Height          =   590
      Left            =   6600
      Picture         =   "frmSweepChart.frx":DD4B
      Stretch         =   -1  'True
      Top             =   240
      Width           =   2700
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Total Test Time"
      Height          =   255
      Left            =   7440
      TabIndex        =   21
      Top             =   6000
      Width           =   1455
   End
End
Attribute VB_Name = "frmSweepChart"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub cmdExcelPlot_Click()
'This procedure takes the data saved to file (data is taken from disk)
'and calls Excel to plot it
'Calling Excel requires project reference to Microsoft Excel 9.0 Object Library

    Dim i As Integer
    Dim ReadNum As Long
    Dim result As String
    Dim t As Double
    Dim row As Integer
    
If Not SaveFileLoaded Then                  'If sweep data isn't saved to disk, save it
    Call frmMain.Save_Click
End If
  
If Not SaveFileLoaded Then                  'User Pressed "Cancel" button, abort Excel plot
    MsgBox "File save error.  Data will not be sent to Excel.", vbExclamation
    Exit Sub
End If
    
    With Excel.Application
      .Workbooks.Open filename:=SaveFileName
      .Visible = True
      With .ActiveWorkbook
        row = DataStartRow                                  'Skip past the text (2520 settings) data
        Do
            row = row + 1
        Loop While .Worksheets(1).Cells(row, 1) <> ""       'Determine last row with data
        If row > DataStartRow + 2 Then                      'Ensure that at least 2 data points are available to chart
            .Charts.Add
            .Charts(1).Activate
            .Charts(1).SeriesCollection(1).Delete
            .Charts(1).Type = xlXYScatter
            .Charts(1).SeriesCollection.Add Source:=.Worksheets(1).Range("A" & DataStartRow & ":" & Chr(64 + DataElements) & row - 1), categoryLabels:=True 'Add all data series to graph, add legends
            .Charts(1).SeriesCollection(1).AxisGroup = xlSecondary                          'Add secondary Y axis, scales for series 1 = LD voltage
        End If
      End With
    End With
    SaveFileLoaded = False

End Sub

Private Sub cmdReplot_Click()
'Replot sweepchart with new graph Scale factors

blnTimeUpdate = False               'Set flag for no updating of sweep time
ChartData                   'Chart data with new graph scale factors

End Sub

Private Sub Command1_Click()
MsgBox "This is a test"
End Sub

Private Sub Form_Initialize()

txtTime.ForeColor = &HFF0000   'set test time text color to green

MSChart1.ChartData = dblGraphArray   'Feed chart with zeros


'Label_Chart                     'fix legend

'Clear the test statistics displays
txtThresoldCurrent = ""
txtKinkMaxima = ""
txtKinkMinima = ""
txtKinkStddev = ""

DoEvents        'update display

End Sub

Public Sub Label_Chart()
'This sub puts the correct labels in the legend of the chart and
'excludes (hides) unnecessary series on the graph, also fills in the
'Sweep parameters

'Update (copy from frmMain) sweep parameters shown on Chart Form
frmSweepChart.txtStart.Text = frmMain.cboStartCurrent.Text
frmSweepChart.txtStop.Text = frmMain.cboStopCurrent.Text
frmSweepChart.txtPulseWidth.Text = frmMain.cboPulseWidth.Text
frmSweepChart.txtPulseDelay.Text = frmMain.cboPulseDelay.Text
frmSweepChart.txtSteps.Text = frmMain.txtSteps.Text


MSChart1.row = 1                    'address row
MSChart1.RowLabel = "LD Current"    'caption row
MSChart1.row = 2
MSChart1.RowLabel = "LD Voltage (right axis)"
MSChart1.row = 3
MSChart1.RowLabel = "Detector 1-FF"
MSChart1.row = 4
MSChart1.RowLabel = "Detector 2-BF"
MSChart1.row = 5
MSChart1.RowLabel = "(dL)2/(dI)2 (right axis)"
MSChart1.row = 6
MSChart1.RowLabel = "dL/dI"
MSChart1.Plot.Axis(VtChAxisIdY, 1).AxisTitle.Text = "Det. Current + Arb. Units for dL/dI"
MSChart1.Plot.Axis(VtChAxisIdY2, 1).AxisTitle.VtFont.Size = 12
MSChart1.Plot.Axis(VtChAxisIdY2, 1).AxisTitle.Text = "LD Voltage + Arb Units for dL2/dI2"
MSChart1.Plot.Axis(VtChAxisIdY, 1).AxisTitle.VtFont.Size = 12

'Increase line width of each series
MSChart1.Plot.SeriesCollection(intLDVolt).Pen.width = 25   'change line width
MSChart1.Plot.SeriesCollection(intDet1Curr).Pen.width = 25   'change line width
MSChart1.Plot.SeriesCollection(intDet2Curr).Pen.width = 25   'change line width
MSChart1.Plot.SeriesCollection(int2ndDeriv).Pen.width = 25   'change line width
MSChart1.Plot.SeriesCollection(int1stDeriv).Pen.width = 25   'change line width

'Change background of chart to white (default= formbackground (=grey))
MSChart1.Backdrop.Fill.Style = VtFillStyleBrush
MSChart1.Backdrop.Fill.Brush.Style = VtBrushStyleSolid
MSChart1.Backdrop.Fill.Brush.FillColor.Set 255, 255, 255

'Hide the LD Current from being charted
MSChart1.Plot.SeriesCollection(intLDCurr).Position.Excluded = True

'Use secondary (right side) y axis for the LD Voltage
MSChart1.Plot.SeriesCollection(intLDVolt).SecondaryAxis = True
MSChart1.Plot.SeriesCollection(int2ndDeriv).SecondaryAxis = True

'For non-Expert mode, hide the Detector 2 series, not necessary
'for resistor DUT because of the det1-det2 configuration
If frmMain.optDUTtype(0).value Or frmMain.optDUTtype(1).value Then
        MSChart1.Plot.SeriesCollection(intDet2Curr).Position.Excluded = True    'Exclude from graph
        MSChart1.row = intDet1Curr
        MSChart1.RowLabel = "Detector"
        txtScaleDet2Curr.Visible = False                'Hide Detector 2 Scale text box
        lblDet2.Visible = False
        lblDet1.Caption = "Det Curr"
        Shape1(2).Visible = False                       'Hide Det 2 color code shape
    Else                                'If the DUT type is Expert then activate Det 2 series
        MSChart1.Plot.SeriesCollection(intDet2Curr).Position.Excluded = False '    MSChart1.Row = intDet1Curr
        MSChart1.RowLabel = "Detector 1-FF"
        txtScaleDet2Curr.Visible = True                 'Display Detector 2 Scale text box
        lblDet2.Visible = True
        lblDet1.Caption = "Det1 Curr"
        Shape1(2).Visible = True
End If

DoEvents    'update display

End Sub

Public Sub ChartData()
'Update the chart object with latest data.
Dim i As Integer

'Set graphing (charting) scale factors for each data set, these are just guesses
'because 2nd derivative plot can vary wildly, so auto-scaled can squash other plots
'using the same y-axis

If blnTimeUpdate Then                   'If not replotting existing data, then update time
    txtTime.Text = (Int(1000 * (Timer - frmMain.StartTime)) / 1000) & " Seconds"        'calculate elapsed time, truncating to left 4 digits
End If

'Copy Array into values to be charted (GraphArray), do Det1-Det2 and apply
'graph Scale factors

For i = 1 To intSteps
    dblGraphArray(intLDCurr, i) = intScaleLDCurr * dblArray(intLDCurr, i)   'Copy & graph Scale LD current values
    dblGraphArray(intLDVolt, i) = CSng(txtScaleLDVolt) * dblArray(intLDVolt, i)
    If frmMain.optDUTtype(2).value Then         'If in expert mode, do not take Det1-Det2 difference
        dblGraphArray(intDet1Curr, i) = CSng(txtScaleDet1Curr) * dblArray(intDet1Curr, i)   'Copy & graph scale Det1 current data
    Else                                        'Using 500mA or 5A DUT, so take Det1-Det2 difference
        dblGraphArray(intDet1Curr, i) = CSng(txtScaleDet1Curr) * (dblArray(intDet1Curr, i) - dblArray(intDet2Curr, i))   'Calc difference, req for resistor DUT
    End If
    dblGraphArray(intDet2Curr, i) = CSng(txtScaleDet2Curr) * dblArray(intDet2Curr, i)     'Copy & scale Det2 current
    dblGraphArray(int2ndDeriv, i) = CSng(txtScale2ndDeriv) * dblArray(int2ndDeriv, i)     'Copy & scale 2nd derivative of Det 1 signal
    dblGraphArray(int1stDeriv, i) = CSng(txtScale1stDeriv) * dblArray(int1stDeriv, i)     'Copy & scale 1st derivative of Det 1 signal

Next i

'Set chart properties and graph data
MSChart1.ColumnCount = intSteps         'scale x axis of chart
MSChart1.ChartData = dblGraphArray      'enter lastest data points
MSChart1.ColumnCount = intSteps         'correct for stray points/replot

Label_Chart                             'fix labels, which get screwed up from charting, for some reason

frmSweepChart.Show                      'Bring up Sweep Chart form

DoEvents    'update form display

End Sub

Private Sub Form_Load()
'Position form on screen
Top = Screen.Height - Height            'Position form in lower right corner
Left = Screen.width - width             'Position form in lower right corner
End Sub
